/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: PacketDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Packet send/receive dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-06-28  initial version

**************************************************************************************/

#pragma once

///////////////////////////////////////////////////////////////////////////////////////////
/// \file PacketDlg.h
///   Packet send/receive dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "cifxuser.h"
#include "hexedit.h"
#include "BaseDialog.h"

//forward declaration
class CCifXDeviceBase;

#define WM_UPDATE_COUNTERS      (WM_USER + 1)
#define WM_UPDATE_SEND          (WM_USER + 2)
#define WM_UPDATE_RECV          (WM_USER + 3)

///////////////////////////////////////////////////////////////////////////////////////////
/// Packet send/receive dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CPacketDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CPacketDlg)

public:
	CPacketDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CPacketDlg();

// Dialog Data
	enum { IDD = IDD_PACKET };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  CIFX_PACKET       m_tSendPacket;        //!< Packet to send to the device
  CIFX_PACKET       m_tRecvPacket;        //!< Last received packet from device
  
  CIFX_PACKET       m_tTempRecvPacket;    //!< Last received packet from device

  unsigned long     m_ulSendCounter;      //!< Number of packets successfully sent
  unsigned long     m_ulRecvCounter;      //!< Number of packets successfully received

  bool              m_fAutoIncrementID;   //!< true if the ID should be automatically incremented each successful send
  bool              m_fSendCyclic;        //!< true if the actual packet should be sent cyclic
  bool              m_fRecvCyclic;        //!< true if the device is to be polled cyclic for new packets

  CHexEdit          m_cSendDestCtrl;      //!< Send packet Dest edit control
  CHexEdit          m_cSendSrcCtrl;       //!< Send packet Src edit control
  CHexEdit          m_cSendDestIDCtrl;    //!< Send packet DestId edit control
  CHexEdit          m_cSendSrcIDCtrl;     //!< Send packet SrcId edit control
  CHexEdit          m_cSendIDCtrl;        //!< Send packet ID edit control
  CHexEdit          m_cSendStateCtrl;     //!< Send packet State edit control
  CHexEdit          m_cSendCmdCtrl;       //!< Send packet Cmd edit control
  CHexEdit          m_cSendExtCtrl;       //!< Send packet Ext edit control
  CHexEdit          m_cSendRoutCtrl;      //!< Send packet Rout edit control

  CHexEdit          m_cRecvDestCtrl;      //!< Receive packet Dest edit control
  CHexEdit          m_cRecvSrcCtrl;       //!< Receive packet Src edit control
  CHexEdit          m_cRecvDestIDCtrl;    //!< Receive packet DestId edit control
  CHexEdit          m_cRecvSrcIDCtrl;     //!< Receive packet SrcId edit control
  CEdit             m_cRecvLenCtrl;       //!< Receive packet Len edit control
  CHexEdit          m_cRecvIDCtrl;        //!< Receive packet ID edit control
  CHexEdit          m_cRecvStateCtrl;     //!< Receive packet State edit control
  CHexEdit          m_cRecvCmdCtrl;       //!< Receive packet Cmd edit control
  CHexEdit          m_cRecvExtCtrl;       //!< Receive packet Ext edit control
  CHexEdit          m_cRecvRoutCtrl;      //!< Receive packet Rout edit control

  CEdit             m_cSendDataCtrl;      //!< Send packet data edit control
  
  CFont             m_cFixedFont;

  CButton           m_cSendAutoIdCtrl;    //!< Checkbox control for automatic ID incrementation
  CButton           m_cSendCyclicCtrl;    //!< Checkbox control for enabling cyclic sending
  CButton           m_cRecvCyclicCtrl;    //!< Checkbox control for enabling cyclic receive

  bool              m_fDeviceAccess;

  DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog(void);

  LRESULT UpdateReceivePacket(WPARAM wParam = 0, LPARAM lParam = 0);
  LRESULT UpdateSendPacket(WPARAM wParam = 0, LPARAM lParam = 0);
  LRESULT UpdateCounters(WPARAM wParam = 0, LPARAM lParam = 0);

  bool          ValidateSendData(void);
  long          PutPacket(void);
  long          GetPacket(ULONG ulMaxPacket = 0);

  virtual void ThreadFunction(void);
  virtual void OnUpdateDevice(CCifXDeviceBase* pcDevice);

  afx_msg void OnBnClickedBtnGetpacket();
  afx_msg void OnBnClickedBtnPutpacket();
  afx_msg void OnBnClickedBtnResetrecv();
  afx_msg void OnBnClickedBtnResetsend();
  afx_msg void OnBnClickedChkSendAutoid();
  afx_msg void OnBnClickedChkSendcyclic();
  afx_msg void OnBnClickedChkRecvcyclic();
  afx_msg void OnEnKillfocusSendData();
  afx_msg void OnEnUpdateSendData();
};
